//Fragment Shader adapted ~Icecave by Elias~ of Shadertoy.com. 
//made compatible with VGHD player thanks to code
//tweeks by @TheEmu (as below). Reduction to speed of z movement and rates of 
//morphing tweeks (viz below where relevant changes as comments) by ET
//## Below is the full form of the set of definitions used  by  TheEmu
//## to adapt fragment shaders from ShaderTot.com to work with the VGHD software.
//## In most cases just copying this file to the start of the shader is all  that
//## is necessary. However, it does not cover all possible cases, notably it does
//## not cover the use of texture cubes.
//##
//## In this file I have included extra explanatory comments using   //##.  These
//## should probably be omitted when using this file yourself as  they  serve  no
//## purpose in the final shader source and clutter it up.
//~@ET kept Emu's comments incl.here because advice is still new to many at VGHD.
/////////////////////////////////////////////////////////////////////////////////

//## Please, always acknowledge the origin of the shader, Add more detail should
//## that be appropriate.

// Original obtained from ShaderToy.com
// Adapted, trivialy, for VGHD by TheEmu.

//## The following definitions equivalencing ShaderToy's  iGlobalTime  to  VGHD's
//## u_Elapsed and iResolution to u_WindowSize and are essentialy always  needed.
//## This could be done by editing the body of the shaders replacing each use  of
//## of iGlobalTime with u_Elapsed and each use of iResolution with u_WindowSize,
//## but it is better no to edit the shaders if it can be avoided.

uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iGlobalTime u_Elapsed
#define iResolution u_WindowSize

/////////////////////////////////////////////////////////////////////////////////

//## Many of ShaderToy's shaders reference iMouse to get the mouse  position  and
//## detect button presses. Often this is not unimportant and static mouse is all
//## that has to be simulated, in which case all that is needed is a simple
//##
//##     #define iMouse vec4(0.0,0.0, 0.0,0.0)
//##
//## but in other cases a dynamic mouse simulation is required,  as  is done here.
//## This simple Automatic Mouse simulates scanning the mouse over the full  range
//## of the screen with the X and Y scanning frequencies being different. The form
//## of the scanning may be altered to suit a particular shader  by  changing  the
//## expression used for MOUSE_POS.  If MOUSE_POS is changed then it should always
//## provide a position bewteen (0.0,0.0) and (u_WindowSize.x,u_WindowSize.y).  It
//## has not yet been necessary to simulate mouse button presses,  but this can be
//## done by changing MOUSE_PRESS should it ever be required. 

#define iMouse AUTO_MOUSE

#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
#define MOUSE_POS   vec2((1.0+cos(iGlobalTime*MOUSE_SPEED))*u_WindowSize/2.0)
#define MOUSE_PRESS vec2(0.0,0.0)
#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )

/////////////////////////////////////////////////////////////////////////////////

//## The ShaderToy shaders often use textures inputs named iChannel0 etc.  which
//## can be configured, outside of the shader source,  to reference an image,  a
//## video or a sound source (or, I think, a keyboard). With VGHD it is possible
//## to use these to access Sprite, ClipSprite or ClipNameSprite data  depending
//## on how the .scn is configured.
//## 
//## Note, the names used here are chosen to match ShaderToy, but in general any
//## names can be used.
//##
//## Note, with VGHD I have not yet been able to discover a way to  access  more 
//## than one texture at a time and so all of the iChannel's declared here  will
//## reference the same texture. This has proved to be of little importance, but
//## may affect the details of the images produced. 

uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;

//## With VGHD the range of the P argument's components of the texture functions
//## is 0.0 to 1.0 whereas with ShaderToy it appears that the upper  limits  are
//## given by the number of pixels in each direction, typically 512 or 64. Hence
//## we use the following functions instead.

vec4 texture2D_Fract(sampler2D sampler,vec2 P)
 { return texture2D(sampler,fract(P));
 }

vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias)
 { return texture2D(sampler,fract(P),Bias);
 }

#define texture2D texture2D_Fract

/////////////////////////////////////////////////////////////////////////////////


#define STEPS 128
//#define STEPS 64
#define PRECISION 0.0001
//#define DEPTH 50.0
#define DEPTH 50.0
#define PI 3.14159265359
//#define RELIEF_Z 0.3
#define RELIEF_Z 0.3
//#define RELIEF_DEPTH 0.01
#define RELIEF_DEPTH 0.01

struct Ray {
	vec3 origin;
	vec3 direction;
};

struct Object {
	vec3 position;
	float distance;
	int material;
};

vec3 eye = vec3(0,0,0);
vec3 light = vec3(0,0,1);
Object scene(vec3);
// decreasing the multiplier of iGlobalTime 
//decreases the speed of forward movement
float t = iGlobalTime*0.08+15.0;
// increase size of iterated textures by increasing + amount eg: 
// float t = iGlobalTime*0.7+15.0; to
// float t = iGlobalTime*0.7+45.0;
float sdCylinder(vec3 p, float r) { return length(p.yx)-r; }

mat3 rotZ(float a){float s=sin(a);float c=cos(a);return mat3(c,-s,0,s,c,0,0,0,1);}
mat3 rotX(float a){float s=sin(a);float c=cos(a);return mat3(1,0,0,0,c,s,0,-s,c);}
mat3 rotY(float a){float s=sin(a);float c=cos(a);return mat3(c,0,-s,0,1,0,s,0,c);}

vec3 getNormal(vec3 p)
{
	vec2 e = vec2(PRECISION,0);
	vec3 n = normalize(vec3(
		scene(p+e.xyy).distance - scene(p-e.xyy).distance,
		scene(p+e.yxy).distance - scene(p-e.yxy).distance,
		scene(p+e.yyx).distance - scene(p-e.yyx).distance
	));
	
	return n;
}

vec3 relief(vec2 p)
{
	vec2 e = vec2(RELIEF_DEPTH,0);
	vec3 n = normalize(vec3(
		length(texture2D(iChannel0,p+e.xy).rgb) - length(texture2D(iChannel0,p-e.xy).rgb),
		length(texture2D(iChannel0,p+e.yx).rgb) - length(texture2D(iChannel0,p-e.yx).rgb),
		RELIEF_Z
	));
	
	return n;
}

Object scene(vec3 p)
{
	vec3 pc = vec3(p.x+sin(p.z),p.y+sin(p.z),p.z);
//change the following line for more randomness
	pc.xy *= vec2(
		sin(p.z+pc.x+pc.y)*
		sin(p.z*2.0-pc.y*p.y)*
		sin(pc.z-p.x*0.25)* //was sin(pc.z-p.x*0.25)* //0.25 was 2.0
		mix(p.x-pc.y,p.y,pc.y*p.x)+
		pc.y*p.x
	);
	float d = max(sdCylinder(pc,0.05),-sdCylinder(pc,0.05));//was0.2 , 0.1
	return Object(p, d, 0);
}

Object march(Ray ray)
{
	float t = 0.0; Object o;
	
	for(int i=0; i < STEPS; i++)
	{
		o = scene(ray.origin + ray.direction * t);
		if (o.distance < PRECISION || t > DEPTH) { break; }
		t += o.distance;
	}
	
	return o;
}


Ray lookAt(vec3 o, vec3 t)
{
	vec2 uv = (2.0 * gl_FragCoord.xy - iResolution.xy) / iResolution.xx;
	vec3 dir = normalize(t-o), up = vec3(0,1,0), right = cross(up,dir);
	return Ray(o,normalize(right*uv.x + cross(dir,right)*uv.y + dir));
}

void main()
{	
	eye.z   += t;
	light.z += t;
	
	eye.y = light.y = -sin(eye.z);
	eye.x = light.x = -sin(eye.z);
	
	Ray ray = lookAt(eye, light);
	ray.direction *= rotX(-cos(eye.z+0.4));
	ray.direction *= rotY(cos(eye.z));
	
	Object o = march(ray);
	
	float res = 5.0;
	vec3 col = texture2D(iChannel0,o.position.xz*res).bgr;
	vec3 bm = relief(o.position.xz*res);
	vec3 n = -normalize(getNormal(o.position)+bm);
		
	float distance = length(light-o.position);
	float diff = max(dot(n, reflect(normalize(light-o.position),n)),0.0);
	float spec = pow(diff, 50.0);
		
	col += diff*vec3(0,0.5,1)+spec*vec3(1,0.5,0);
	col *= min(1.0, 1.0/distance);

	gl_FragColor = vec4(col,1.0);
}